/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.crafting.recipe;

import com.chrisgli.gemsnjewels.util.ModCrafting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class JeweledItemRecipe
extends ShapelessRecipe {
    private JeweledItemRecipe(ResourceLocation id, String group, ItemStack recipeOutput, NonNullList<Ingredient> ingredients) {
        super(id, group, recipeOutput, ingredients);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack output = super.m_5874_(inv);
        if (!output.m_41619_()) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack ingredient = inv.m_8020_(i);
                if (ingredient.m_41619_() || !(ingredient.m_41720_() instanceof SwordItem) && !(ingredient.m_41720_() instanceof PickaxeItem) && !(ingredient.m_41720_() instanceof AxeItem) && !(ingredient.m_41720_() instanceof ShovelItem) && !(ingredient.m_41720_() instanceof HoeItem)) continue;
                for (Object key : ingredient.m_41784_().m_128431_()) {
                    if (ingredient.m_41737_((String)key) == null || ((String)key).equals("RepairCost") || ((String)key).equals("Damage") || ((String)key).equals("Enchantments")) continue;
                    output.m_41700_((String)key, (Tag)ingredient.m_41737_((String)key));
                }
                Map map = EnchantmentHelper.m_44831_((ItemStack)ingredient);
                for (Enchantment enchantment : map.keySet()) {
                    output.m_41663_(enchantment, ((Integer)map.get(enchantment)).intValue());
                }
                int newDamage = ClampedInt.m_146395_((IntProvider)ConstantInt.m_146483_((int)ingredient.m_41773_()), (int)0, (int)output.m_41776_()).m_142737_();
                output.m_41721_(newDamage);
                break;
            }
        }
        return output;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModCrafting.Recipes.JEWELED_UPGRADE_SHAPELESS.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<JeweledItemRecipe> {
        public JeweledItemRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            ItemStack result = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("result"), (boolean)true);
            return new JeweledItemRecipe(recipeId, group, result, ingredients);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray p_44276_) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < p_44276_.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)p_44276_.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public JeweledItemRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int numIngredients = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)numIngredients, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new JeweledItemRecipe(recipeId, group, result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, JeweledItemRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

